require 'rubygems'
require 'Appscript'
include Appscript

# function for getting palette index from rgb value
def rgb2index(rgb, palette)
    index = 0
    minError = 3*255**2
    palette.each_with_index  do |palette,i|
        error =  (palette[0]-rgb[0])**2+(palette[1]-rgb[1])**2+(palette[2]-rgb[2])**2 
        if(error < minError)
            index = i
            minError = error
        end
    end
    index + 1
end

# パレットカラーのRGB値をファイルから取得
# cf. http://dmcritchie.mvps.org/excel/colors.htm
paletteColors = []
File.open("/Users/jun/Desktop/indexRGBs.csv").read.split( "\r" ).each do |line|
    paletteColors << line.split(",").map{ |v| v.to_i }
end

excel = app('Microsoft Excel') # エクセルに接続
excel.activate # 最前面へ
csheme = excel.theme_color_scheme # カラースキームを取得
chart = excel.active_chart # チャート取得


MIN = ARGV[0].to_f # グラフ彩色の最小値
MAX = ARGV[1].to_f # グラフ彩色の最大値
UNIT = ARGV[2].to_f # 刻み幅
TRANSPARENCY = ARGV[3] # 透明度

xAxis = chart.get_axis(:axis_type => :value_axis, :which_axis => :primary_axis)
xAxis.minimum_scale.set( MIN )
xAxis.maximum_scale.set( MAX )
xAxis.major_unit.set( UNIT )

count = ( (MAX - MIN) / UNIT ).to_i + 1

targetColors = []
count.times do |i|
    r = 0
    g = 128-(255*i/count-128).abs
    b = 0
    r = 2 * ( 127 * i / (count/2) ).to_i if(255*i/count > 128)
    b = 2 * ( 127 - 127 * i / (count/2) ).to_i if(255*i/count < 128)
    targetColors << [ r, g, b ]
end

legend = chart.legend_object
entries = legend.legend_entries
count.times do |i|
    entry = entries[i]
    fill = entry.legend_key.chart_fill_format_object
        fill.foreground_scheme_color.set rgb2index( targetColors[i], paletteColors )
    fill.transparency.set TRANSPARENCY
end
